/* namopen.c - namopen */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <name.h>

/*------------------------------------------------------------------------
 *  namopen  -  open an object (e.g., remote file) based on the name
 *------------------------------------------------------------------------
 */
namopen(devptr, filenam, mode)
struct	devsw	*devptr;
char	*filenam;
char	*mode;
{
	int	dev;
	int	ret;
	char	*newname;

    if ((newname=getmem(NAMLEN)) == NULLPTR)
		return(SYSERR);
	if ( (dev=nammap(newname, filenam)) == SYSERR) {
		freemem(newname,NAMLEN);
        return(SYSERR);
	}
    ret = nopen(dev, newname, mode);
	freemem(newname,NAMLEN);
	return(ret);
}
