; xeidi.asm - _sys_xdisabl, _sys_xrestor, _sys_pcxget, _sys_getstk

	public	_sys_xdisabl, _sys_xrestor, _sys_pcxget, _sys_getstk
        
	public	pcxflag, sssave, spsave


_TEXT   SEGMENT WORD PUBLIC 'CODE'
        ASSUME CS:_TEXT, DS:NOTHING

pcxflag		dw	1		; zero when rescheduling disabled 
spsave          dw      ?               ; saved stack pointer register
sssave		dw	?		; saved stack segment register


;-------------------------------------------------------------------------
; _sys_xdisabl  --  return pcxflag & disable context switching
;-------------------------------------------------------------------------
; int sys_xdisabl()
_sys_xdisabl	proc	far
        pushf
        cli                     ; disable interrupts
	xor	ax,ax
        xchg    ax,cs:pcxflag
        popf
	ret
_sys_xdisabl	endp

;-------------------------------------------------------------------------
; _sys_xrestor  --  restore pcxflag
;-------------------------------------------------------------------------
; sys_xrestor(ps)
; int ps;
_sys_xrestor	proc	far
	push	bp
	mov	bp,sp		; C calling convention
        pushf
        cli                     ; disable interrupts
	mov	ax,[bp+6];	; get passed flags word
        mov     cs:pcxflag,ax   ; reset pcxflag to passed value
        popf
	pop	bp
	ret
_sys_xrestor	endp

;-------------------------------------------------------------------------
; _sys_pcxget  --  get the current value of pcxflag
;-------------------------------------------------------------------------
; int sys_pcxget()
_sys_pcxget	proc	far
	pushf
	cli			; disable interrupts
        mov     ax,cs:pcxflag
	popf
	ret
_sys_pcxget	endp

;-------------------------------------------------------------------------
; sys_getstk  --  get the stack parameters for panic printing
;-------------------------------------------------------------------------
; int *sys_getstk()
_sys_getstk	proc	far
	mov	ax,cs:spsave
	mov	dx,cs:sssave
	ret
_sys_getstk	endp


_TEXT ENDS

	end
