/* xdone.c - xdone */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <io.h>
#include <disk.h>
#include <tty.h>

extern char *memptr;
extern int run;

/*------------------------------------------------------------------------
 *  xdone  --  print system termination message and terminate PC-Xinu
 *------------------------------------------------------------------------
 */
int xdone()
{
	int	kprintf();
    int ps, i, ret;

#ifdef Ndsk
	for ( i=0; i<Ndsk; i++ )
		control(dstab[i].dnum,DSKSYNC);	/* sync the disks	*/
#endif
#ifdef Nsio
    sleep(1);                           /* let tty output settle    */
#endif
    disable(ps);
#ifdef WINDOWS
    scrollup(0,0x184f,0,7);             /* clear the screen     */
#endif
    for ( i=0 ; i<NDEVS ; i++) {
        ret = init(i,0);                /* un-initialize device */
        if (ret != OK)
            kprintf("xdone: error un-initializing device %d\n", i);
    }
	kprintf("\n\n-- system halt --\n\n");
	if (numproc==0)
		kprintf("All user processes have completed\n");
	else
        kprintf("terminated with %d process%s active\n",
			numproc, ((numproc==1) ? "" : "es"));
    kprintf("Returning to DOS . . .\n\n");
    disable(ps);
    maprestore();                       /* restore IRQs */
    free(memptr);                       /* return malloced memory */
    run=FALSE;                          /* kill the NULL process */    
    return OK;
}
