/* map.c - mapinit, maprestore */

#include <dos.h>
#include <conf.h>
#include <kernel.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  mapinit  --  fill in an intmap table entry using DOS getvect, setvect
 *------------------------------------------------------------------------
 */
int mapinit(vec,newisr,mdevno)
int vec;                    /* interrupt vector no.		*/
int (*newisr)();			/* addr. of new service routine	*/
int mdevno;                 /* minor device number		*/
{
    int i;                  /* intmap entry         	*/
    struct intmap_t *imp;	/* pointers to intmap		*/
    int flag;				/* upper byte of vector		*/
	union REGS regs;
    struct SREGS sregs;
    int ps;
        
	i = nmaps;
	if ( i >= NMAPS )
		return(SYSERR);
	nmaps++;
	imp = &sys_imp[i];		/* point to our intmap entry	*/
    flag = (vec>>8) & 0xff; /* pick up flag byte        */
	vec = vec & 0xff;		/* only low-order byte counts	*/

/* set up the input intmap entry */
	imp->iflag = flag;		/* deposit flag byte in iflag	*/

/* DOS get_vect */

    regs.h.ah=0x35;
    regs.h.al=vec;
    intdosx(&regs,&regs,&sregs);
    imp->oldisr_seg = sregs.es;
    imp->oldisr_off = regs.x.bx;
    disable(ps);                /* be SURE ints are off */

/* DOS set_vect */

    regs.h.ah=0x25;
    regs.h.al=vec;
    sregs.ds=FP_SEG(imp);
    regs.x.dx=FP_OFF(imp)+1;
    intdosx(&regs,&regs,&sregs);
    disable(ps);                /* be SURE ints are off */

	imp->newisr = newisr;		/* our input handler		*/
	imp->mdevno = mdevno;		/* minor device no.		*/
	imp->ivec = (char) vec;		/* interrupt vector		*/
    return(OK);
}

/*------------------------------------------------------------------------
 *  maprestore  --  restore all old interrupt vectors from the intmap
 *------------------------------------------------------------------------
 */
int maprestore()
{
    int i;                  /* intmap entry number      */
	struct 	intmap_t *imp;	/* pointers to intmap		*/
	union	REGS regs;
    struct  SREGS sregs;
    int ps;
    
	if ( nmaps > NMAPS )
		nmaps = NMAPS;		/* just to be sure		*/
    for (i=0; i<nmaps; i++) {
		imp = &sys_imp[i];	/* point to this intmap entry	*/
		if ( (int)(imp->newisr) == -1 )
			continue;	/* if unused entry		*/

        /* DOS set_vector */

        regs.h.ah=0x25;
        regs.h.al=imp->ivec;
        sregs.ds=imp->oldisr_seg;
        regs.x.dx=imp->oldisr_off;
        intdosx(&regs,&regs,&sregs);
        disable(ps);                /* be SURE ints are off */

	}
}
