/* initialize.c - main, sysinit */

#include <dos.h>
#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <proc.h>
#include <sem.h>
#include <q.h>
#include <shell.h>
#include <butler.h>
#include <pc.h>
#include <kbdio.h>
#include <bufpool.h>



#ifdef	Ntty
#include <tty.h>
int winofcur;               /* define the current input window  */
struct tty  tty[Ntty];      /* window buffers and mode control  */
#endif


#ifdef 	Nmf
#include <mffile.h>
struct mfblk mftab[Nmf];
#endif

/* Declarations of major kernel variables */

struct  pentry  proctab[NPROC];     /* process table            */
int     nextproc;                   /* next process slot to use in create */
struct  sentry  semaph[NSEM];       /* semaphore table          */
int     nextsem;                    /* next semaphore slot to use in screate*/
struct  qent    q[NQENT];           /* q table (see queue.c)        */
int     nextqueue;                  /* next slot in q structure to use  */

MBLOCK  memlist;                    /* list of free memory blocks       */
para endaddr;                       /* beginning of free memory (was para)*/
para maxaddr;                       /* end of free memory (was para)*/

/* PC-specific variables */

int     nmaps;                      /* no. of active intmap entries     */

/* active system state */

int     numproc;                    /* number of live user processes    */
int     currpid;                    /* id of currently running process  */
char    *memptr;                    /* mallocated memory */
int     run;                        /* TRUE while Xinu is running */

/* real-time clock variables and sleeping process queue pointers	*/

long    tod;                        /* time-of-day (tics since startup) */
long    startup;
int     defclk;                     /* non-zero, then deferring clock count */
int     clkdiff;                    /* deferred clock ticks         */
int     slnempty;                   /* FALSE if the sleep queue is empty    */
int     *sltop;                     /* address of key part of top entry in  */
                                    /* the sleep queue if slnonempty==TRUE  */
int     clockq;                     /* head of queue of sleeping processes  */
int     preempt;                    /* preemption counter.  Current process */
                                    /* is preempted when it reaches zero;   */
                                    /* set in resched; counts in ticks  */

/* local typedef declaration */

typedef	unsigned long	big;

/* miscellaneous system variables */

int     butlerpid;                  /* pid of butler process        */
int     sysmsg;                     /* message queue            */
int     rdyhead,rdytail;            /* head/tail of ready list (q indexes)  */

extern unsigned _stklen;
char    *sys_stknpr();
unsigned long curr_sp; 

#define NULLNM  "**NULL**"          /* null process name            */

/************************************************************************/
/***                NOTE:                                             ***/
/***                                                                  ***/
/***   This is where the system begins after the C environment has    ***/
/***   been established.  Interrupts are initially DISABLED, and      ***/
/***   must eventually be enabled explicitly.  This routine turns     ***/
/***   itself into the null process after initialization.  Because    ***/
/***   the null process must always remain ready to run, it cannot    ***/
/***   execute code that might cause it to be suspended, wait for a   ***/
/***   semaphore, or put to sleep, or exit.  In particular, it must   ***/
/***   not do I/O unless it uses kprintf for console output.          ***/
/***                                                                  ***/
/************************************************************************/

/*------------------------------------------------------------------------
 *  main  --  initialize system and become the null process (id==0)
 *------------------------------------------------------------------------
 */
main(argc,argv)                     /* babysit CPU when no one home */
int argc;
char *argv[];
{
    int     xmain();                /* user's main procedure    */
    int     butler();               /* BUTLER process       */
    int     ps;                     /* save processor flags     */
    int     pcx;                    /* reschedule flag      */
    big     maxmem;                 /* maximum memory location  */
    big     endmem;                 /* start of free memory     */

    curr_sp = (unsigned long) sys_stknpr(); /* save current stack pointer */
    
    while ( kbdgetc() != NOCH )     /* eat remaining kbd chars  */
            ;
    kprintf("Initializing . . .\n");
    disable(ps);
    xdisable(pcx);
    if ( sysinit() == SYSERR ) {    /* initialize all of PC-Xinu    */
		kprintf("PC-Xinu initialization error\n");
		maprestore();
		restore(ps);
		exit(1);
	}
	restore(ps);
    gettime(&startup);
    maxmem = (big)maxaddr << 4;
    endmem = (big)endaddr << 4;
    kprintf("\nXINU Version %s\n", VERSION);
    kprintf("%lu real mem\n",maxmem);
    kprintf("%lu base addr\n",endmem);
    kprintf("%lu avail mem\n\n", maxmem - endmem);
    xrestore(pcx);                  /* XINU is now running */
    run=TRUE;

    /* start the butler process */

    butlerpid=create(butler,BTLRSTK,BTLRPRIO,BTLRNAME,0); 
    resume(butlerpid);

    /* create the user process */
    resume(create(xmain,0x800,INITPRIO,"xmain",3,argc,argv));

    while (run)                 /* run until someone tells us to stop */
       pause();
}

#define UL	unsigned long

/*------------------------------------------------------------------------
 *  sysinit  --  initialize all PC-Xinu data structures and devices
 *------------------------------------------------------------------------
 */

LOCAL sysinit()
{
	int		i,j;
	struct pentry	*pptr;
	struct sentry	*sptr;
	struct mblock	*mptr;
    char    *farmalloc();           /* C memory allocator       */
    int     xdone();                /* terminate xinu       */
    char    *namep;                 /* null process name pointer    */
    word    nblks;                  /* number of paragraphs to get  */
    para    sizmem;                 /* memory sizing        */
    struct devsw *dvptr;            /* pointer to devtab entry  */
    unsigned long avmem;
    char *ptr;
    int ps;
            
    nmaps=0;                        /* no. of active intmap entries */
    numproc = 0;                    /* initialize system variables  */
	nextproc = NPROC-1;
	nextsem = NSEM-1;
    nextqueue = NPROC;              /* q[0..NPROC-1] are processes  */

    avmem = coreleft();                 /* determine bytes of memory left */
    memptr=farmalloc(avmem);            /* get the lot */
    disable(ps);                        /* farmalloc turns ints on ! */
    sizmem=avmem >> 4;                  /* convert to paragraphs */
    endaddr = FP_SEG(memptr);           /* start of free memory (para)  */
	if (FP_OFF(memptr) != 0){
		sizmem--;
        endaddr++;                      /* adjust to para boundary  */
	}
    maxaddr = endaddr + sizmem;         /* top of free memory (para)    */
    memlist.mnext = endaddr;            /* initialize free memory list  */
	memlist.mlen = sizmem;

    mptr = (MBLOCK *)MK_FP(endaddr,0);
	mptr->mnext = 0;
	mptr->mlen = sizmem;

    for (i=0 ; i<NPROC ; i++)       /* initialize process table */
		proctab[i].pstate = PRFREE;

    ptr = &proctab[0];
    for (i=0 ; i<sizeof(struct pentry); i++)
        ptr[i]=0;
     
    pptr = &proctab[NULLPROC];      /* initialize null process entry */
    pptr->pstate = PRCURR;
    pptr->pprio = 0;
    pptr->oldtime = 0;
    pptr->time = 0;
  
    ptr = sys_stknpr();
    pptr->pbase = (char *) (sys_stknpr() - FP_OFF(ptr));	// compute pbase
    pptr->pregs = (char *) sys_stknpr();					// current sp
    pptr->ssize = 0x1000;								// I happen to know this
    
    namep=NULLNM;
    for (j=0; j<PNMLEN; j++)
        pptr->pname[j] = (*namep ? *namep++ : ' ');
    pptr->pname[PNMLEN] = '\0';
    pptr->paddr = main;
    pptr->pargs = 0;

#ifdef Nsio
	/* STDIN, STDOUT, STDERR */
	for (i=0 ; i < Nsio ; i++)
		pptr->pdevs[i] = (i<3) ? CONSOLE : BADDEV;
#endif

    currpid = NULLPROC;

    for (i=0 ; i<NSEM ; i++) {      /* initialize semaphores    */
		(sptr = &semaph[i])->sstate = SFREE;
		sptr->sqtail = 1 + (sptr->sqhead = newqueue());
	}
    rdytail=1+(rdyhead=newqueue()); /* initialize ready list */

#ifdef	MEMMARK
    _mkinit();                      /* initialize memory marking    */
#else
    pinit();                        /* initialize ports     */
    poolinit();                     /* initialize the buffer pools  */
#endif

    clkinit();                      /* initialize real-time clock   */

#ifdef	Ndsk
    dskdbp=mkpool(DBUFSIZ, NDBUFF); /* initialize disk buffers     */
	dskrbp= mkpool(DREQSIZ, NDREQ);
#endif

#ifdef	Ntty
    winofcur = 0;                   /* initialize current window    */
#endif

/* set up low-level interrupt vectors */

    mapinit(DB0VEC, _panic, DB0VEC);        /* divide by zero   */
    mapinit(SSTEPVEC, _panic, SSTEPVEC);    /* single step      */
    mapinit(BKPTVEC, _panic, BKPTVEC);      /* breakpoint       */
    mapinit(OFLOWVEC, _panic, OFLOWVEC);    /* overflow     */
    mapinit(CBRKVEC, cbrkint, CBRKVEC);     /* ctrl-break       */

#ifdef	NDEVS
	for ( i=0 ; i<NDEVS ; i++ ) {	/* initialize devices		*/
		dvptr = &devtab[i];
		if ( dvptr->dvivec && mapinit(dvptr->dvivec,
				dvptr->dviint, dvptr->dvminor) == SYSERR )
			goto uninit;
		if (dvptr->dvovec && mapinit(dvptr->dvovec,
				dvptr->dvoint, dvptr->dvminor) == SYSERR )
			goto uninit;
		if (init(i,1) == OK)	/* initialize the device */
			continue;
uninit:
		kprintf("initiali.c: error initializing device %d\n", i);
		while (--i > 0)
			init(i,0);
		return(SYSERR);
	}
#endif

    if (mapinit(CLKVEC|BIOSFLG, clkint, 0) == SYSERR)
        return(SYSERR);

   return(OK);
}
