/* getss.c -- get_cur_ss  
 * 
 * check if stack saved in sssave/spsave is that of current process
 */

/*          ** call only with ints disabled **                 */


#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <dos.h>

extern long sys_getstk();
extern int kprintf();

int get_cur_ss()
{
	long curr_stk;
	long proc_stk_base;
	long proc_stk_top;
	int ret;

	curr_stk = (long) sys_getstk();

	proc_stk_base = (long) proctab[currpid].pbase;
	proc_stk_top  = (long) proctab[currpid].pbase + 
					proctab[currpid].ssize;

	ret = (curr_stk >= proc_stk_base) && (curr_stk <= proc_stk_top);

#ifdef DEBUG
#define STKMSG "\
Interrupted code stack pointer:       %lx\n\
Interrupted process stack base-limit: %lx-%lx\n\n"
	if (!ret)
		kprintf(STKMSG, curr_stk, proc_stk_base, proc_stk_top);				
#endif

	return(ret); 
}
