/* die.c - die */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <sem.h>
#include <dos.h>
#include <io.h>

/*------------------------------------------------------------------------
 * die  --  terminate the current process and remove it from the system
 *------------------------------------------------------------------------
 */
SYSCALL die(pid)
int pid;
{
	struct	pentry	*pptr;
	int	i;
	int 	ps;
	int	nok;
/*	para	xb;
	XBLOCK	*xbp;
	word	npara;
	word	alloc;
*/
	disable(ps);
    pptr = &proctab[pid];       /* was currpid */
	pptr->pprio = MAXINT;		/* make sure we go away fast	*/
	pptr->pimmortl = TRUE;		/* disable any further kills	*/

	/* close standard devices */
	for (i=0 ; i<Nsio ; i++)
		close(pptr->pdevs[i]);

	/* inform next of kin about our death */
	nok = pptr->pnxtkin;
	pptr->pnxtkin = BADPID;
    if ( nok != pid )           /* was currpid */
        send(nok, pid);         /* was currpid */

	/* free allocated memory */
/*	xb = pptr->pmlist;
	if (xb == 0)
		panic("die: missing stack block");
	xbp = (XBLOCK *)memp(xb);		// location of stack block 
	xb = xbp->xbback;				// tail of list 
	xbp->xbback = 0;				// make sure chase ends!
	alloc = 0;
	while (xb != 0) {
		xbp = (XBLOCK *)memp(xb);
		npara = xbp->xblen;
		alloc += npara;
		xb = xbp->xbback;			// work backwards to stack block
		if (freemem((char *)xbp,npara<<4) == SYSERR)
			panic("die: unable to free allocated memory");
	}
	if (alloc != pptr->pmalloc)
		panic("die: inconsistent memory allocation");
*/

/*	N.B.: avendo rinunciato agli XBLOCK, devo almeno liberare il blocco
 *	la memoria allocata da \t create() per il processo che ora muore.
 *	Credo che questo blocco sia concatenato con lo slot pmlist, se si
 *	usano gli XBLOCK
 */
	freestk(pptr->pbase, pptr->plen);

	if ( --numproc == 0 )
		xdone();

	pptr->pstate = PRFREE;	/* suicide */
	resched();
	restore(ps);		/* never gets here */
}
