;- ctxsw.asm - ctxsw

	include ..\h\dos.asm

dseg
endds

pseg
	public	_ctxsw

;-------------------------------------------------------------------------
;- ctxsw  --  context switch from old process to new process
;-------------------------------------------------------------------------
;- void ctxsw(void * op, void * np);
;-------------------------------------------------------------------------
; Per Xinu/8086, il contesto : CS:IP, BP, FLAGS, SI, DI, DS, SS:SP
; Il contesto di un processo non corrente risiede: 
; - sul suo stack (CS:IP, BP, FLAGS, SI, DI, DS) dal basso verso l'alto
; - in opportune locazioni di memoria (SS:SP).
;
;- ctxsw(op,np)
;    salva il contesto del chiamante, il vecchio processo corrente, sul suo stack, 
;    e SS:SP alla dword puntata da op;
;
;    pone la dword puntata da np in SS:SP, rendendo lo stack quello
;    del nuovo processo corrente; da questo stack preleva (dall'alto verso il basso) 
;    la parte di contesto DS, DI, SI, FLAGS, BP;
;
;    ora CS:IP del nuovo processo e` in cima allo stack e il RET finale lo ripristina.
;
; Il chiamante mette i far pointer op, np sullo stack prima della chiamata.
;-------------------------------------------------------------------------

_ctxsw	proc	far		; _ is for C compilers
				; NB: here sp points to old process' ret address
	push	bp
	mov	bp,sp		; set stack frame to access op as [bp+6], np as [bp+10]
	pushf			; save flags (especially interrupt flag)
	cli			; disable interrupts just to be sure
	push    si		; preserve old process' registers
	push    di
	push    ds		; not in Xinu (bcc puts it in resched() anyway)
	les	bx,[bp+6]	; copy to es:bx dword [bp+6] (far pointer to save area for ss:sp)
	mov	es:[bx],sp	; copy to its save area current (far) stack pointer ss:sp
	mov	es:[bx+2],ss
	les	bx,[bp+10]	; dword [bp+10] is far pointer to save area for
	mov	sp,es:[bx]	;    ss:sp of new process
	mov	ss,es:[bx+2]
;-----------------------------	; now ss:sp points to new process' stack
	pop	ds		; restore new process' registers
	pop	di
	pop	si
	popf                    ; restore new process' interrupt state
	pop	bp		; stack top now new process' ret address
	ret			; return to what new process was doing

_ctxsw	endp

endps
	end