/* mem.h - roundp, getstk, freestk */

/*---------------------------------------------------------------------------
 * roundp - round address to next paragraph 
 *---------------------------------------------------------------------------
 */


#ifndef MEM
#define MEM

#define roundp(x)	( (15 + (para)(x)) & (~15) )

#define memp(x)		( (char *)MK_FP(x,0) )
#define seg(x)		FP_SEG(x)
#define off(x)		FP_OFF(x)

typedef struct	mblock	{
    para mnext;		// n.paragrafo a 16 bit indirizza 2^16 paragrafi=2^20 byte	
    word mlen;		// lunghezza blocco (in paragrafi)
} MBLOCK;
#define memnext(x)	(((MBLOCK *)(x))->mnext)
#define memlen(x)	(((MBLOCK *)(x))->mlen)


#define MMAX 65000			/* maximum memory size      */
#define MMIN 512			/* minimum Xinu Allocation  */
#define MDOS 1024			/* save something for MS-DOS	*/

extern	MBLOCK	memlist;	/* head of free memory list	*/
extern  para maxaddr;		/* max memory address (was para) */
extern  para endaddr;		/* address beyond loaded mem (was para)*/

extern char *getmem();
extern int freemem(char *, int);

#define getstk(n)		getmem(n)
#define freestk(b,s)	freemem(b,s)


/* Declarations for \t xalloc(), \t xfree() */ 

typedef struct xblock {
	para xbback, xbfore;   /* was para */
	para xblen;            /* was word */
} XBLOCK;

extern char *xmalloc();
extern char *xcalloc();
extern int xfree();

#ifdef TURBOC
extern 	unsigned long	coreleft();	/* bytes available from C heap	*/
#else
extern	char	*sys_stkhqq();		/* get lower stack boundary	*/
#endif


#endif
