/* dos.h */

struct WORDREGS	{
	unsigned int ax, bx, cx, dx, si, di, cflag, flags;
};

struct BYTEREGS	{
	unsigned char al, ah, bl, bh, cl, ch, dl, dh;
};

union	REGS {
	struct	WORDREGS x;
	struct	BYTEREGS h;
};

struct	SREGS	{
	unsigned int es, cs, ss, ds;
};

#define INT86(n,r)	int86((n),(r),(r))
#define INT86X(n,r,s)	int86x((n),(r),(r),(s))

#define FP_SEG(fp) 	(*((unsigned *)&(fp) + 1))
#define FP_OFF(fp) 	(*((unsigned *)&(fp)))
#define MK_FP(seg,ofs)	((void far *)(((unsigned long)(seg) << 16) | (ofs)))

#define AH(r)		((r).h.ah)
#define AL(r)		((r).h.al)
#define BH(r)		((r).h.bh)
#define BL(r)		((r).h.bl)
#define CH(r)		((r).h.ch)
#define CL(r)		((r).h.cl)
#define DH(r)		((r).h.dh)
#define DL(r)		((r).h.dl)
#define AX(r)		((r).x.ax)
#define BX(r)		((r).x.bx)
#define CX(r)		((r).x.cx)
#define DX(r)		((r).x.dx)
#define SI(r)		((r).x.si)
#define DI(r)		((r).x.di)
#define CF(r)		((r).x.cflag)
#define DS(r)		((r).ds)
#define ES(r)		((r).es)

#define UNSIGNED(x)	  ( *( (unsigned int *) &(x) ) )	/* alias! */


