/* xfree.c -- xfree */

#include <conf.h>
#include <kernel.h>
#include <dos.h>
#include <mem.h>
#include <proc.h>

/*--------------------------------------------------------------------------
 * xfree -- free memory allocated by xmalloc or xcalloc
 *--------------------------------------------------------------------------
 */
SYSCALL xfree(mp)
char *mp;
{
	XBLOCK	*xmp;
	word	npara;
	int	ret;
	int	ps;

	if (mp == NULL)
		return(SYSERR);
	disable(ps);
	xmp = ((XBLOCK *)mp)-1;
	if (off(xmp) != 0) {
		restore(ps);
		return(SYSERR);
	}
	npara = xbdelete(xmp, currpid);
	if (freemem(xmp, npara<<4) == SYSERR)
		panic("xfree: inconsistent memory allocation");
	restore(ps);
	return(OK);
}
