/* login.c - login */

#include <conf.h>
#include <kernel.h>
#include <shell.h>
#include <sleep.h>
#include <mem.h>

#ifdef NETWORK
#include <network.h>
#endif


#define BUFLEN  128

LOCAL   char    *shargs[] = {SHNAME, "startup"};

struct  loginfo Log;                         /* login information */

/*------------------------------------------------------------------------
 *  login  -  log user onto system
 *------------------------------------------------------------------------
 */
login()
{
	int     len;
	char    *buf;

	Log.lused = FALSE;
	Log.luser[0] = NULLCH;
	buf = getmem((word) BUFLEN);
	while (TRUE) {
		printf(VERSION);
		printf("\nlogin: ");
		while (TRUE) {
			len=read(STDIN,buf,BUFLEN); 
/*
			if ((len==1) || strncmp(buf,"dc\n",len)) {
				printf("\nSorry, you are not authorized to use Xinu.");
				xdone();
				return OK;
			}
*/
			break;
		}
		if (len == EOF) {
			read(STDIN, buf, 0);
			Log.lused = FALSE;
			continue;
		}
		buf[len-1] = NULLCH;
		strncpy(Log.luser, buf, SHNAMLEN-1);
		Log.luser[SHNAMLEN-1] = NULLCH;
		Log.ldev = getpdev(getpid(),STDIN);
		gettime(&Log.llogin);
		Log.llast = Log.llogin;
		Log.lused = TRUE;
#ifdef MEMMARK
		mark(Log.lmark);
#endif
		freemem(buf, (word) BUFLEN);
		shell(2,shargs);  /* use 1 for no window, 2 for windows*/
		return OK;
	}
}
