/* getutim.c - getutim */

#include <conf.h>
#include <kernel.h>
#include <dos.h>
#include <sleep.h>
#include <date.h>



/*------------------------------------------------------------------------
 * getutim  --  obtain time in seconds past Jan 1, 1970, ut (gmt)
 *------------------------------------------------------------------------
 */
SYSCALL	getutim(timvar)
long	*timvar;
{
	static	int	utinit = 0;
	int	year;
	int	i;
	union	REGS regs;
	long	tmptime;
	extern	struct datinfo Dat;	/* defined in ascdate.c */


	wait(clmutex);
	if (utinit != 0) {	/* no need to initialize */
		*timvar = clktime;
		signal(clmutex);
        return(OK);
	}

	regs.h.ah = 0x2a;   /* MS-DOS get date function */
	intdos(&regs,&regs);
	tmptime = 0L;
	for ( year = 1970; year < regs.x.cx ; year++ )
		tmptime += isleap(year) ? 366L : 365L;
	regs.h.dh--;		/* months (0..11) */
	for ( i = 0; i < (int)regs.h.dh ; i++ )
		tmptime += (long)Dat.dt_msize[i];
	if ( i >= 2 && isleap(year) )
		tmptime += 1L;
	regs.h.dl--;		/* days (0..30) */
	tmptime += (long)(regs.h.dl);
	tmptime *= SECPERDY;	/* convert to seconds */

	regs.h.ah = 0x2c;	/* MS-DOS get time function */

	intdos(&regs,&regs);
	tmptime += (long)regs.h.ch*SECPERHR;
	tmptime += (long)regs.h.cl*SECPERMN;
	tmptime += (long)regs.h.dh;
	clktime = ltim2ut(tmptime);

	*timvar = clktime;
	utinit = 1;
	signal(clmutex);
	return(OK);
}
