; Quest'esempio illustra la gestione dei registri di segmento in BC3.1, 
; con il modello di memoria HUGE.

; Un modulo TEST.C chiama fun() esterna, definita p.es. in FUN.C.

; Compilare il modulo F.C da` luogo ai segmenti
;    F_DATA segment word public use16 'FAR_DATA'
;    F_TEXT segment word public use16 'CODE'
; Di fatto, la combine-class PUBLIC non ha effetto, perche' nessun 
; altro modulo ASM conterra` segmenti di ugual nome.
; Le classi 'FAR_DATA' e 'CODE' assicurano che i segmenti dati dei
; vari moduli risultino contigui nel file eseguibile, cosi` per i segmenti
; di codice.
; I segmenti risultano comunque distinti dal punto di vista della generazione
; degli indirizzi.

; Conseguenze: 
;  -  le chiamate a funzioni definite in moduli esterni devono essere far
;  -  le funzioni devono essere compilate come far (escono con retf)
;  -  anche le chiamate intra-modulo devono essere far

; All'ingresso nelle funzioni del modulo TEST:
; -  ds viene inizializzato al segmento TEST_DATA
; -  per le variabili di TEST non serve override; p.es.:
;	mov	word ptr _x[bx],1
; -  es viene usato per accedere alle variabili esterne; p.es.:
;	mov	ax,seg _y
;	mov	es,ax
;	mov	word ptr es:_y[bx],0

; N.B.: l'operatore seg su un rif. esterno viene interpretato dal linker.

; Una funzione C come test():
; *  modifica DS, ma lo salva in ingresso/ripristina in uscita
; *  modifica ES, ma non lo preserva.
;
; test() presume lo stesso di fun(), per cui dopo aver chiamato fun():
; *  non ripristina DS (lo presume inalterato)
; *  ricarica ES (perche' fun() potrebbe averlo sporcato)
;
; In XINU, il context switch (routine _ctxsw) non salva:


	.386p
	assume	cs:TEST_TEXT,ds:TEST_DATA

   ;	extern int y[];
   ;	int i;
   ;	int x[20000];

	extrn	_y:word
	public	_i
	public	_x
	public	_test
	extrn	_fun:far

TEST_DATA	segment word public use16 'FAR_DATA'
_i	dw	?
_x	dw	20000 dup (?)
TEST_DATA	ends


TEST_TEXT	segment byte public use16 'CODE'
   ;	
   ;	test()
   ;	
	assume	cs:TEST_TEXT
_test	proc	far
	push	ds
	mov	ax,TEST_DATA
	mov	ds,ax
   ;	
   ;	{
   ;		i = 9000;
   ;	
	mov	word ptr _i,9000
   ;	
   ;		x[i] = 1;
   ;	
	mov	bx,word ptr _i
	shl	bx,1
	mov	word ptr _x[bx],1
   ;	
   ;		y[i] = 0;
   ;	
	mov	bx,word ptr _i
	shl	bx,1
	mov	ax,seg _y
	mov	es,ax
	mov	word ptr es:_y[bx],0
   ;	
   ;		fun();			// NB: se si omette la chiamata
	call	far ptr _fun		;   |
   ;					    |
   ;		y[i] = 1;		//  |
	mov	bx,word ptr _i		;   |
	shl	bx,1			;   v
	mov	ax, seg _y		;  verra` omessa quest'istruzione
	mov	es,ax
	mov	word ptr es:_y[bx],1

   ;		fun();
   ;	
	call	far ptr _fun
   ;	
   ;		y[i] = 1;
   ;	
	mov	bx,word ptr _i
	shl	bx,1
	mov	ax,seg _y
	mov	es,ax
	mov	word ptr es:_y[bx],1


   ;	
   ;	
   ;	}
   ;	
	pop	ds
	ret	
_test	endp

TEST_TEXT	ends

	end
