import javax.swing.*;
import java.awt.*;
import java.awt.event.*;        // ActionListener per i radiobutton
import javax.swing.event.*;     // ActionListener per i radiobutton
import javax.swing.table.*;

class FrameLatchSR extends JFrame{
    private boolean disegna;
    private int newS=1, newR=0;
    private int valS=1, valR=0, valQ=1, valQn=0, alterna=0;
    private int valOld[]={1,0,1,0}; //  = {S,R,Q,Q'} valori in memoria prima
                                    // di cambiare stato
    private static int yS=20, xD=30, yD=15, yH=40, xW=(500+xD);
    private int limY[][]={{yS+yH, yS+yH-30},
                                    {yS+yH+(yH+yD), yS+yH+(yH+yD)-30},
                                    {yS+yH+(yH+yD)*2, yS+yH+(yH+yD)*2-30},
                                    {yS+yH+(yH+yD)*3, yS+yH+(yH+yD)*3-30}};
    private boolean isSuspend=false;

    private int xpos, pause = 16, giri;
    private JButton Inizia = new JButton("Start Simulator");
    private JButton Stop = new JButton("Stop");
    private JButton Chiudi = new JButton("Exit");
    private String[] Assi={"S", "R","Q","Q'"};
    private Color c[] = {Color.red, Color.blue, Color.black, Color.magenta};
    private Color sfondo;
    private Color colore01[] = {Color.white,Color.blue};

    public FrameLatchSR(){
        this.setDefaultLookAndFeelDecorated(true);
        setTitle("Simulatore Latch SR");
        setSize(610, 570);
        setLocation(100,5);
        sfondo = getBackground();
        //this.setUndecorated(true);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        Container pane = getContentPane();
        pane.setBackground(new Color(192,192,192));
        pane.add(new mioPanel());
    }

    //---------------------------------------------------------------------
    // classe mioPanel : contiene i pannelli ( pulsanti e disegni )
    //---------------------------------------------------------------------
    class mioPanel extends JPanel implements ActionListener{
        private JRadioButton A1 = new JRadioButton("(S,R)=(0,0)");
        private JRadioButton A2 = new JRadioButton("(S,R)=(0,1)");
        private JRadioButton A3 = new JRadioButton("(S,R)=(1,0)",true);
        private JRadioButton A4 = new JRadioButton("(S,R)=(1,1)");

        private ButtonGroup gruppo;
        private JPanel JPInput,JPTest,JPTitolo,JPSliderB;
        private JPMessage JPMsg,JPLegenda;
        private JPLatch JPLatchSR;
        private Grafici JPGraphic;
        private JSlider speedB= new JSlider(JSlider.HORIZONTAL,1,15,8);

        public void paintComponent(Graphics g){
            super.paintComponent(g);
            // bordo doppio rettangolo blu-verde
            // Bordo Input e e circuito Latch SR
            g.setColor(new Color(0,0,255));
            g.drawRect(3,3,380,230);
            g.setColor(new Color(0,255,0));
            g.drawRect(4,4,380,230);
            // Bordo Titolo
            g.setColor(new Color(0,0,255));
            g.drawRect(390,3,204,40);
            g.setColor(new Color(0,255,0));
            g.drawRect(391,4,204,40);
            // Bordo Messaggi
            g.setColor(new Color(0,0,255));
            g.drawRect(390,47,204,186);
            g.setColor(new Color(0,255,0));
            g.drawRect(391,48,204,186);
            // fine bordo
        }
        
        public void EnabledRadio(boolean bvalue){
            A1.setEnabled(bvalue);
            A2.setEnabled(bvalue);
            A3.setEnabled(bvalue);
            A4.setEnabled(bvalue);
        }


        class JPMessage extends JPanel {
            private Image ImageMsg;
            private String FileMsg;
            private int x, y, w, h;
            public JPMessage(String FileMess){
                visualizza(FileMess);
            }
 
            public void paintComponent(Graphics g){
                super.paintComponent(g);
                ImageMsg = Toolkit.getDefaultToolkit().getImage("img/"+FileMsg); // carico l'immagine
                MediaTracker tracker = new MediaTracker(this); // creo un MediaTracker
                tracker.addImage(ImageMsg,0); // adesso il tracker controlla l'immagine che viene identificata  con 0
                try { tracker.waitForID(0); } // il tracker attende il caricamento dell'immagine
                catch (InterruptedException e) {}
                g.drawImage(ImageMsg,x,y,w,h,this);
            }
            
            public void visualizza(String FileMess){
                FileMsg=FileMess;
                if (FileMsg == "legenda.gif") {
                    x=10;
                    y=0;
                    w=121;
                    h=26;
                }
                else {
                    x=1;
                    y=0;
                    w=200;
                    h=183;
                }
                repaint();
            }
        }
        
        public mioPanel() {
            // cotruttore
            super();
            int i;

            // creo i pannelli che comporranno il pannello
            setLayout(null);

            JPTitolo=new JPanel();
            JPInput=new JPanel();
            JPLatchSR=new JPLatch(); // JPLatchSR.setBackground(Color.red);
            JPMsg = new JPMessage("msgstart.gif"); //JPMsg.setBackground(Color.green);
            JPLegenda = new JPMessage("legenda.gif"); //JPLegenda.setBackground(Color.red);
            JPSliderB=new JPanel();
            JPTest=new JPanel();
            JPGraphic=new Grafici();

            // aggiungo i pulsanti al Listener
            A1.addActionListener(this);
            A2.addActionListener(this);
            A3.addActionListener(this);
            A4.addActionListener(this);
            Inizia.addActionListener(this);
            Stop.addActionListener(this);
            Chiudi.addActionListener(this);

            // setto propriet pulsanti
            Stop.setEnabled(false);

            // aggiungo i pulsanti ad un gruppo
            gruppo=new ButtonGroup();
            gruppo.add(A1);gruppo.add(A2);
            gruppo.add(A3);gruppo.add(A4);
            
            // scelta Font e Colore per il titolo
            JPTitolo.setFont(new Font("TimesRoman",Font.BOLD,18));
            JPTitolo.setForeground(new Color(0,0,255));
            JPTitolo.add(new Label("Latch SR - Simulator"));

            JPInput.setForeground(new Color(0,0,255));
            JPInput.setFont(new Font("TimesRoman",Font.BOLD,18));
            JPInput.add(new Label("Input"));

            JPInput.add(A1,null); JPInput.add(A2,null);
            JPInput.add(A3,null); JPInput.add(A4,null);
            JPTest.add(Inizia);
            JPTest.add(Stop);
            JPTest.add(Chiudi);

            speedB.addChangeListener(new ChangeListener() {
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource()==speedB) {
                        pause = 32 - (speedB.getValue() * 2);
                    }
                }});

            JPTitolo.setBounds(410,6,160,30);
            JPLegenda.setBounds(10,10,132,28);
            JPInput.setBounds(7,45,147,160);
            JPLatchSR.setBounds(165,25,200,171);
            JPSliderB.setBounds(165,196,200,29);
            JPLatchSR.setBounds(165,25,200,171);
            JPSliderB.setBounds(163,196,200,29);
            JPMsg.setBounds(392,49,200,183);
            JPGraphic.setBounds(0,240,600,250);
            JPTest.setBounds(0,495,600,40);

            JPSliderB.add(speedB);

            aggiungi(JPInput);
            aggiungi(JPLegenda);
            aggiungi(JPLatchSR);
            aggiungi(JPSliderB);
            aggiungi(JPTitolo);
            add(JPMsg);
            aggiungi(JPTest);
            aggiungi(JPGraphic);
                
            EnabledRadio(false);
            JPLegenda.setVisible(false);
            JPInput.repaint();
        }
        public void aggiungi(Object obj){
            add((Component)obj);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource()==Inizia) {
                //EnabledRadio(true);
                JPInput.repaint();
                JPGraphic.Inizia();
                JPLatchSR.Inizia(0);
                JPLegenda.setVisible(true);
                if ((valS==1) && (valR==0)) {
                    JPMsg.visualizza("msg1010.gif");
                }
                
            }
            if (e.getSource()==Stop) {
                EnabledRadio(false);
                JPGraphic.Stop();
                JPLatchSR.Stop();
                JPLegenda.setVisible(false);
            }
            if (e.getSource()==Chiudi) {
                //dispose();
                System.exit(0);
            }
            if (e.getSource()==A1) {
                newS=0; 
                newR=0; 
                EnabledRadio(false); 
                giri=0;
                if (valQ==valQn){
                    // Ciclo Infinito: questa configurazione puo' portare
                    // ad un ciclo infinito dei valori Q e Qn 
                    //JPTavola.setVisible(false);
                    JPMsg.visualizza("msg0000.gif");
                }
               
                else if (valQ != valR){
                    // Configurazione errata
                    // comporta la perdita della complementarit di Q e Qn
                    JPMsg.visualizza("msg00.gif");
                }
            }
            if (e.getSource()==A2) {
                newS=0; 
                newR=1; 
                EnabledRadio(false); 
                giri=0;
                JPMsg.visualizza("msg0101.gif");
            }
            if (e.getSource()==A3) {
                newS=1; 
                newR=0; 
                EnabledRadio(false); 
                giri=0;
                JPMsg.visualizza("msg1010.gif");
            }
            if (e.getSource()==A4) {
                newS=1; 
                newR=1; 
                EnabledRadio(false); 
                giri=0;
                // configurazione errata
                JPMsg.visualizza("msg1100.gif");
            }
            disegna = true;
        }

        class JPLatch extends Panel implements Runnable {
            private int memX, memY;
            private int memAx[][]={{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
            private int memAy[][]={{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
            private Thread disegnalinee;
            private Image latch;
            private int posA, index;
            private boolean primavolta=true;
            String ImageLatch;
            private int lineeA[][][] = { {{38,15,80,16},{38,144,80,145}},
                                         {{112,21,123,22},{112,138,124,139}},
                                         {{130,21,152,22},{130,138,153,139}},
                                         {{126,25,128,49},{126,136,127,113}},
                                         {{126,47,60,113},{126,114,60,48}},
                                         {{60,113,61,133},{60,48,61,28}},
                                         {{60,132,80,133},{60,27,80,28}}
                                       };
            public void immagine(Graphics g){
                latch = Toolkit.getDefaultToolkit().getImage(ImageLatch); // carico l'immagine
                MediaTracker tracker = new MediaTracker(this); // creo un MediaTracker
                tracker.addImage(latch,0); // adesso il tracker controlla l'immagine che viene identificata  con 0
                try { tracker.waitForID(0); } // il tracker attende il caricamento dell'immagine
                catch (InterruptedException e) {}
                g.drawImage(latch,10,0,175,171,this);
            }

            public void paint(Graphics g){
                super.paint(g);
                if (disegnalinee == null) {
                    primavolta=false;
                    ImageLatch = "img/latch.gif";
                    immagine(g);//}
                }
                else {
                    ImageLatch = "img/latch1.gif";
                    traccia(g);
                    if (disegna) {
                        // ogni volta che cambia stato
                        disegna=false;
                        immagine(g);
                    }
                }
            }

            public void update(Graphics g) {
                paint(g);
            }
            
            private void Aggiorna(String uscita){
                // Aggiorna i valori di Q e Q' in funzione del
                // del parametro "uscita"
                if (uscita=="SR") {
                    valS = newS;
                    valR = newR;}
                else {
                    valOld[2] = valQ;
                    valOld[3] = valQn;
                    if ( (valR+valOld[3]) >0) {valQ = 0;}
                    else {valQ = 1;}
                    if ( (valS+valOld[2]) >0) {valQn = 0;}
                    else {valQn = 1;}
                }

            }
            public void traccia(Graphics g){
                /*            0,0             figura latch
                         S o-----------|\ 1,0  2,0
                                    6,1|A 0---+-----o Qn=Q'
                                   +---|/    |3,0
                                5,1|         |
                                    \       /4,0
                                      \   /
                                        x
                                      /   \ 4,1
                                    /       \
                              5,0  |         |
                                   +---|\    |3,1
                                    6,0| 0---+-----o Q
                         R o-----------|/ 1,1  2,1
                               0,1
                */
                int i,j,k,y1;//, tmpQ, tmpQn, idx;
                if (posA < lineeA.length){
                    for (i=index; i<=posA; i++){
                        switch (i){
                            case 0:{
                                // valS
                                g.setColor(colore01[valS]);
                                g.fillRect(lineeA[i][0][0], 
                                lineeA[i][0][1], 
                                (memAx[i][0]-lineeA[i][0][0])+1,
                                (lineeA[i][0][3]-lineeA[i][0][1])+1 );
                                // valR
                                g.setColor(colore01[valR]);
                                g.fillRect(lineeA[i][1][0],
                                            lineeA[i][1][1],
                                            (memAx[i][1]-lineeA[i][1][0])+1,
                                            (lineeA[i][1][3]-lineeA[i][1][1])+1 );
                                if (memAx[i][0] == lineeA[i][0][2]){
                                    // aggiorna i valori di uscita di Q e Q'
                                    Aggiorna("Q");
                                    Aggiorna("Qn");}
                                break;}                                
                            case 1:{
                                // valQn
                                g.setColor(colore01[valQn]);
                                g.fillRect(lineeA[i][0][0],
                                            lineeA[i][0][1],
                                            (memAx[i][0]-lineeA[i][0][0])+1,
                                            (lineeA[i][0][3]-lineeA[i][0][1])+1 );
                                // valQ
                                g.setColor(colore01[valQ]);
                                g.fillRect(lineeA[i][1][0],
                                            lineeA[i][1][1],
                                            (memAx[i][1]-lineeA[i][1][0])+1,
                                            (lineeA[i][1][3]-lineeA[i][1][1])+1 );
                                break;}
                            case 2:{
                                g.setColor(colore01[valQn]);
                                g.fillRect(lineeA[i][0][0],
                                            lineeA[i][0][1],
                                            (memAx[i][0]-lineeA[i][0][0])+1,(lineeA[i][0][3]-lineeA[i][0][1])+1 );
                                g.fillRect(lineeA[i+1][0][0],
                                            lineeA[i+1][0][1],
                                            2, 
                                            (memAy[i+1][0]-lineeA[i+1][0][1])+1 );
                                g.setColor(colore01[valQ]);
                                g.fillRect(lineeA[i][1][0],
                                            lineeA[i][1][1],
                                            (memAx[i][1]-lineeA[i][1][0])+1,(lineeA[i][1][3]-lineeA[i][1][1])+1 );
                                int x2[] = {lineeA[i+1][1][0],lineeA[i+1][1][0]+2,lineeA[i+1][1][0]+2,lineeA[i+1][1][0]};
                                int y2[] = {lineeA[i+1][1][1],lineeA[i+1][1][1],memAy[i+1][1],memAy[i+1][1]};
                                g.fillPolygon(x2,y2,4);

                                break;}
                            case 3:{
                                break;}
                            case 4:{
                                int x4[] = {lineeA[i][0][0],lineeA[i][0][0]+2,memAx[i][0]+2,memAx[i][0]};
                                int y4[] = {lineeA[i][0][1],lineeA[i][0][1]+1,memAy[i][0]+1,memAy[i][0]};
                                // DISEGNA LA DIAGONALE Q'
                                g.setColor(colore01[valQn]);
                                g.fillPolygon(x4,y4,4);
                                // DISEGNA LA DIAGONALE Q
                                g.setColor(colore01[valQ]);
                                int x4_1[] = {lineeA[i][1][0],lineeA[i][1][0]+2,memAx[i][1]+2,memAx[i][1]};
                                int y4_1[] = {lineeA[i][1][1],lineeA[i][1][1]-1,memAy[i][1]-1,memAy[i][1]};
                                g.fillPolygon(x4_1,y4_1,4);
                                if (memAx[i][0] == lineeA[i][0][2]){
                                    // all'uscita aggiorna i valori di S ed R
                                    Aggiorna("SR");}
                                break;}
                            case 5:{
                                // DISEGNA LA DIAGONALE Q'
                                int x5[] = {lineeA[i][0][0],lineeA[i][0][0]+2,lineeA[i][0][0]+2,lineeA[i][0][0]};
                                int y5[] = {lineeA[i][0][1],lineeA[i][0][1],memAy[i][0]+1,memAy[i][0]};
                                g.setColor(colore01[valQn]);
                                g.fillPolygon(x5,y5,4);

                                // DISEGNA LA DIAGONALE Q
                                g.setColor(colore01[valQ]);
                                int x5_1[] = {lineeA[i][1][0],lineeA[i][1][0]+2,lineeA[i][1][0]+2,lineeA[i][1][0]};
                                int y5_1[] = {lineeA[i][1][1],lineeA[i][1][1],memAy[i][1]-1,memAy[i][1]};
                                g.fillPolygon(x5_1,y5_1,4);

                                // DISEGNA S
                                memX = (lineeA[i][1][1]-memAy[i][1])+1;
                                g.setColor(colore01[valS]);
                                g.fillRect(lineeA[0][0][0],lineeA[0][0][1],memX,2);
                                // DISEGNA R
                                g.setColor(colore01[valR]);
                                g.fillRect(lineeA[0][1][0],lineeA[0][1][1],memX,2);
                                break;}
                            case 6:{
                                g.setColor(colore01[valQn]);
                                g.fillRect(lineeA[i][0][0],lineeA[i][0][1], 
                                    (memAx[i][0]-lineeA[i][0][0])+1,
                                    (lineeA[i][0][3]-lineeA[i][0][1])+1 );
                                g.setColor(colore01[valQ]);
                                g.fillRect(lineeA[i][1][0], lineeA[i][1][1],
                                    (memAx[i][1]-lineeA[i][1][0])+1,
                                    (lineeA[i][1][3]-lineeA[i][1][1])+1 );
                                // continuazione della linea S
                                g.setColor(colore01[valS]);
                                g.fillRect(lineeA[0][0][0],lineeA[0][0][1],memX+(memAx[i][0]-lineeA[i][0][0])+2,2);
                                // continuazione della linea R
                                g.setColor(colore01[valR]);
                                g.fillRect(lineeA[0][1][0],lineeA[0][1][1],memX+(memAx[i][0]-lineeA[i][0][0])+2,2);
                                
                                if (memAx[i][0] == lineeA[i][0][2]){
                                    // aggiorna i valori di uscita di Q e Q'
                                    Aggiorna("QQn");}
                                break;}
                        }
                    }
                }
            }

            public void Inizia(int start) {
                if (disegnalinee != null) Stop();
                disegnalinee = new Thread(this);
                index=start;
                disegnalinee.start();
            }
            
            public void Sleep(){
                Sleep(pause);
            }
            public void Sleep(int tempo){
                pause = tempo;
                repaint();
                try { disegnalinee.sleep(pause); }
                catch (InterruptedException e) { }
            }
                    
            public void run() {
                int jj,kk,kk1,conta;
                while (disegnalinee!=null) {
                    for (posA=index; posA<lineeA.length; posA++){
                       switch (posA){
                            case 0:{
                                for (jj=lineeA[posA][0][0]; jj<=lineeA[posA][0][2]; jj++){
                                    memAx[posA][0]=jj;
                                    memAx[posA][1]=jj;
                                    Sleep();
                                };
                                break;}
                            case 1:{
                                for (jj=lineeA[posA][0][0]; jj<=lineeA[posA][0][2]; jj++){
                                    memAx[posA][0]=jj;
                                    memAx[posA][1]=jj;
                                    Sleep();
                                };
                                break;}
                            case 2:{
                                kk = (lineeA[posA+1][0][3] - lineeA[posA+1][0][1]);
                                conta=0;
                                for (jj=lineeA[posA][0][0]; jj<=lineeA[posA][0][2]; jj++){
                                    memAx[posA][0]=jj;
                                    memAx[posA][1]=jj;
                                    // disegna quelle verticale posA=3
                                    if (conta < kk) {
                                        memAy[posA+1][0] = lineeA[posA+1][0][1]+conta;
                                        memAy[posA+1][1] = lineeA[posA+1][1][1]-conta;
                                    }
                                    conta++;
                                    Sleep();
                                };
                                break;}
                            case 3:{
                                break;}
                            case 4:{
                                // percorre la diagonali all'indietro (cio dall'uscita delle porte verso l'ingresso)
                                for (jj=lineeA[posA][0][0], kk=lineeA[posA][0][1], kk1 = lineeA[posA][1][1];
                                    (jj>=lineeA[posA][0][2] && kk<=lineeA[posA][0][3] && kk1 >= lineeA[posA][1][3]);
                                    jj--,kk++, kk1--) {
                                    memAx[posA][0]=jj;
                                    memAy[posA][0]=kk;
                                    memAx[posA][1]=jj;
                                    memAy[posA][1]=kk1;
                                    Sleep();};
                                break;}
                            case 5:{
                                for (jj=lineeA[posA][0][1], kk=lineeA[posA][1][1]; 
                                        (jj<=lineeA[posA][0][3] && kk >= lineeA[posA][1][3]); 
                                        jj++, kk--){
                                    memAy[posA][0]=jj;
                                    memAy[posA][1]=kk;
                                    Sleep();};
                                break;}
                            case 6:{
                                for (jj=lineeA[posA][0][0]; jj<=lineeA[posA][0][2]; jj++){
                                    memAx[posA][0]=jj;
                                    memAx[posA][1]=jj;
                                    Sleep();};
                                break;}
                        };
                    }
                    index=1;
                    if (giri < 2){giri++;}
                    
                    if (giri == 2){
                        EnabledRadio(true);
                    }
                }
            }
            
            public void Stop() {
                if (disegnalinee != null) {
                    disegnalinee.stop();
                    disegnalinee = null;
                    repaint();
                }
            }
        }

        class Grafici extends Panel implements Runnable {
            private Thread test;
            public void Grafici() {
                repaint();
            }
            public void Inizia() {
                if (test != null) Stop();

                Inizia.setEnabled(false);
                Stop.setEnabled(true);

                test = new Thread(this);
                test.start();
            }

            public void Stop() {
                if (test != null) {
                    Inizia.setEnabled(true);
                    Stop.setEnabled(false);
                    test.stop();
                    test = null;
                    repaint();
                }
            }

            public void run() {
                while (test!=null) {
                    for (xpos = xD; xpos <= xW; xpos++) {
                        repaint();
                        try { test.sleep(150); }
                        catch (InterruptedException e) { }
                    }
                    xpos = xD;
                }
                Stop();
            }

            public void update(Graphics g) {
                paint(g);
            }


            void disegnaAssi(Graphics g) {
                // DEFINISCE I PUNTI PER DISEGNARE LE FRECCE asse Y  di S, R, Q, Q'
                int xP[] ={xD+xW, xD+xW, xD+xW+10};
                int xPy[]={xD-3,xD+3,xD};
                int yM=0, j;
                
                //cancella la parte del grafico
                g.setColor(sfondo);
                g.fillRect(0,0,600,230);
                
                // bordo doppio rettangolo blu-verde
                g.setColor(new Color(0,0,255));
                g.drawRect(4,0,590,238);
                g.setColor(new Color(0,255,0));
                g.drawRect(5,1,590,238);
                // fine bordo
                
                // Mette il Titolo al grafico
                g.setColor(new Color(0,0,255));
                //g.drawString("Rappresentazione grafica dei valori S, R, Q e Q'",180,20);
                g.drawString("graphic representation of the values S R Q and Q'",180,20);

                // disegna gli assi cartesiani di S R Q Q'
                for (j=0; j<4; j++) {
                    g.setColor(Color.gray);
                    yM = (yH + yD)*j;
                    // DISEGNA GLI ASSI Y di S,R,Q,Q'
                    g.drawLine(xD, yS+yM, xD, yS+yH+yM);
                    // DISEGNA GLI ASSI X di S,R,Q,Q'
                    g.drawLine(xD, yS+yH+yM, xD+xW, yS+yH+yM);
                    // DISEGNA LE FRECCE dell'asse Y di S,R,Q,Q'
                    int[] yPy = {yS+yM, yS+yM, yS+yM-10};
                    g.fillPolygon(xPy, yPy, 3);
                    // DISEGNA LE FRECCE dell'asse X di S,R,Q,Q
                    int[] yPx = {yS+yH +yM -3, yS+yH+yM+3, yS+yH+yM};
                    g.fillPolygon(xP, yPx, 3);
                    // SCRIVE I CARATTERI  S, R, Q, Q'
                    g.setColor(c[j]);
                    g.setFont(new Font("TimesRoman",Font.BOLD,14));
                    g.drawString(Assi[j], xD-20, yS+yM+20);
                }
            }

            public void paint(Graphics g) {
                int valNew[] = {valS, valR, valQ, valQn};
                int j, k, i, l;
                if ((test==null) || (xpos==xD)) {
                    disegnaAssi(g);
                }
                else {
                    for (i = 0; i < 4; i++) {
                        j=valOld[i];
                        k=valNew[i];
                        g.setColor(c[i]);
                        if (valOld[i] != valNew[i])
                            // disegna la linea verticale se cambiano uno
                            // dei seguenti valori S,R,Q,Qn
                            g.drawLine(xpos, limY[i][j]-1, xpos, limY[i][k]-1);
                        // linea orizzonatale
                        g.drawLine(xpos, limY[i][valNew[i]]-1, xpos+k, limY[i][valNew[i]]-1);
                        valOld[i] = valNew[i];
                    }
                }
            }
        }
    }
}
public class LatchSR {
    public static void main(String[] args)
    {
        JFrame frame= new FrameLatchSR();
        frame.show();
    }
}
