﻿package 
{

	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.text.TextField;

	public class principale extends MovieClip
	{
		var carattere:int = 0;
		var bits:int = -1;
		var parola:String;
		//var testo: TextField = new TextField();
		var contatore : Array = new Array(
		[0,0,0],
		[0,0,1],
		[0,1,0],
		[0,1,1],
		[1,0,0],
		[1,0,1],
		[1,1,0],
		[1,1,1]
		);


		public function principale()
		{
			stop();
			inizializza();
			load_btn.alpha = 0.3;
			load_btn.enabled = false;
			start_btn.alpha = 0.3;
			start_btn.enabled = false;
			conferma.addEventListener(MouseEvent.CLICK,verifica);
		}

		private function verifica(evt:MouseEvent)
		{
			if (! conferma.enabled)
			{
				return;
			}
			if (testo.text != "")
			{
				load_btn.addEventListener(MouseEvent.CLICK,loadReg);
				start_btn.removeEventListener(MouseEvent.CLICK,Move);
				load_btn.alpha = 1;
				load_btn.enabled = true;
				start_btn.alpha = 0.3;
				start_btn.enabled = false;
				conferma.alpha = 0.3;
				conferma.enabled = false;
				avviso.visible = false;
				parola = testo.text;
				testo.type = "dynamic";
				testo.selectable = false;
				conferma.removeEventListener(MouseEvent.CLICK,verifica);
			}
		}

		private function inizializza()
		{
			//testo.x = 51.85;
			//testo.y = 535,00;
			//testo.width = 367,10;
			//testo.height = 34,10;
			//testo.maxChars = 10;
			//testo.border = true;
			//testo.type = "input";
			//testo.selectable = true;
			//addChild(testo);
			conferma.setText("Conferma");
			load_btn.setText("Carica Registro");
			start_btn.setText("start");
			descr.text = "Per iniziare la simulazione inserire una frase nella casella di testo e premere il tasto conferma.";
			var f1:FlipFlip_D;
			var f2:FlipFlip_R;
			for (var i:int = 0; i<8; i++)
			{
				f1 = getChildByName("r"+i) as FlipFlip_D;
				f1.SetName("r"+i);
			}
			for (var j:int = 0; j<3; j++)
			{
				f2 = getChildByName("c"+j) as FlipFlip_R;
				f2.SetName("c"+j);
			}

		}

		private function loadReg(evt:MouseEvent)
		{
			if (carattere < parola.length)
			{
				start_btn.setText("start");
				clearReg();
				clearCont();
				loadRegistri();
				carattere++;
				bits = 0;
				load_btn.removeEventListener(MouseEvent.CLICK,loadReg);
				start_btn.addEventListener(MouseEvent.CLICK,Move);
				start_btn.alpha = 1;
				start_btn.enabled = true;
				load_btn.alpha = 0.3;
				load_btn.enabled = false;
			}
		}


		private function Move(Evt:MouseEvent)
		{
			gotoAndStop(bits);
			bits++;


			if (bits==0 && carattere < parola.length )
			{
				clearReg();
				load_btn.addEventListener(MouseEvent.CLICK,loadReg);
				start_btn.removeEventListener(MouseEvent.CLICK,Move);
				start_btn.alpha = 0.3;
				start_btn.enabled = false;
				load_btn.alpha = 1;
				load_btn.enabled = true;
				start_btn.setText("Start");
				gotoAndStop(1);
				return;
			}

			if (bits>0 && bits <9 )
			{
				start_btn.setText("Next");
				gotoAndStop(bits+1);
				incCont(bits-1);
				switchReg(bits-1);
				descr.text = "Il registro Contatore contiene il numero " +(bits-1)+
				             "\ne quindi il contenuto del flipflop R" +(bits-1)+ " viene trasferito in uscita.";
			}

			if (bits == 0 && carattere == parola.length )
			{
				resetAllReg();
				testo.text = "";
				descr.text = "Per iniziare la simulazione inserire una frase nella casella di testo e premere il tasto conferma.";
				carText.text = "";
				bits = -1;
				carattere = 0;
				load_btn.removeEventListener(MouseEvent.CLICK,loadReg);
				start_btn.removeEventListener(MouseEvent.CLICK,Move);
				start_btn.alpha = 0.3;
				start_btn.enabled = false;
				load_btn.alpha = 0.3;
				load_btn.enabled = false;
				conferma.alpha = 1;
				conferma.enabled = true;
				conferma.addEventListener(MouseEvent.CLICK,verifica);
				avviso.visible = true;
				testo.type = "input";
				testo.selectable = true;
				return;
			}

			if (bits==8)
			{
				bits = -1;
			}
		}

		private function incCont(index:int)
		{
			var cont:FlipFlip_R;
			clearCont();
			for (var i:int = 0; i<3; i++)
			{
				cont = getChildByName("c"+(2-i)) as FlipFlip_R;
				cont.gotoAndStop(contatore[index][i]+1);
				cont.SetText(""+contatore[index][i]);
			}
		}

		private function clearCont()
		{
			var cont:FlipFlip_R;
			for (var i:int = 0; i<3; i++)
			{
				cont = getChildByName("c"+i) as FlipFlip_R;
				cont.gotoAndStop(1);
				cont.SetText("0");
			}
		}

		private function switchReg(index: int)
		{
			var ff:FlipFlip_D;
			var AND:PortaAnd;
			clearReg();
			for (var i:int = 0; i<8; i++)
			{
				AND = getChildByName("p"+i) as PortaAnd;
				ff = getChildByName("r"+i) as FlipFlip_D;
				if (i==index)
				{
					AND.gotoAndStop(2);
					ff.gotoAndStop(2);
				}
			}
		}

		private function clearReg()
		{
			var ff:FlipFlip_D;
			var AND:PortaAnd;
			for (var i:int = 0; i<8; i++)
			{
				ff = getChildByName("r"+i) as FlipFlip_D;
				ff.gotoAndStop(1);
				AND = getChildByName("p"+i) as PortaAnd;
				AND.gotoAndStop(1);
			}
		}

		private function loadRegistri()
		{
			var bit:Array = decode(parola.charAt(carattere));
			descr.text = "Caricato nel registro il codice binario della lettera  \"" + parola.charAt(carattere) + "\"";
			carText.text = parola.charAt(carattere);
			var ff:FlipFlip_D;
			for (var i:int = 0; i<8; i++)
			{
				ff = getChildByName("r"+i) as FlipFlip_D;
				ff.SetText(bit[7-i]);
				ff.SetName("r"+i);
			}
		}

		private function decode(c:String):Array
		{
			var numero:int = c.charCodeAt(0);
			var a:Array=new Array();
			for (var i : int = 0; i<8; i++)
			{
				a[7 - i] = numero % 2;
				numero /=  2;
			}
			return a;
		}

		private function resetAllReg()
		{
			var ff:FlipFlip_D;
			var rr:FlipFlip_R;
			var AND:PortaAnd;
			for (var i:int = 0; i<8; i++)
			{
				ff = getChildByName("r"+i) as FlipFlip_D;
				ff.gotoAndStop(1);
				ff.SetText("");
				if (i<3)
				{
					rr = getChildByName("c"+i) as FlipFlip_R;
					rr.gotoAndStop(1);
					rr.SetText("");
				}
				AND = getChildByName("p"+i) as PortaAnd;
				AND.gotoAndStop(1);
			}
		}

	}

}