/**
*	Simulatore dell'Allocazione di blocchi a file su disco
*	
*	Il software mostra il funzionamento, a fini didattici, di un simulatore di allocazione di blocchi
*	a file su disco, e simula creazione, lettura, scrittura, eliminazione degli stessi.
*	
*	Il seguente codice può essere liberamente distribuito e migliorato purché ciò non sia fatto per
*	scopi di lucro. Per eventuali comunicazioni potete contattarmi a questo indirizzo: jessicamailweb@gmail.com
*/
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Component;
import java.awt.Color;
import static javax.swing.GroupLayout.Alignment.*;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import java.awt.Graphics2D; 
import java.awt.image.BufferedImage; 
import javax.imageio.ImageIO; 
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import java.util.regex.*;
import java.io.Console;
import java.nio.charset.Charset;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import static java.lang.System.out;
/**
* La classe "AllocazioneSuDisco" contiene gli attributi e i metodi necessari a simulare
* l'allocazione di blocchi a file su disco, e quindi creazione, lettura, scrittura, eliminazione degli stessi.
* Viene creato e visualizzato il frame principale del programma, attraverso il quale 
* l'utente fornirà gli input necessari e visualizzerà i dati.
*
* @author Jessica Catania 
* @version 1.0
*/
public class AllocazioneSuDisco extends JFrame implements ActionListener
{	
	private JButton button1; /** Bottone "Scrivi un file..." */
	private JButton button2; /** Bottone "Elimina file..." */
	private JButton button3; /** Bottone "Formatta" */
	private JLabel c1, c2, c3, c4, c5, sfondo, sfondonum, sfondoset;
	private int spazioOccupato;
	private int spazioDisponibile;
	private String [][] ElencoFile; /** Array bidimensionale contenente i dati dell'elenco dei file */
	private String [][] BitMap; /** Array bidimensionale contenente i dati della Bit Map */
	private String [][] FAT; /** Array bidimensionale contenente i dati della FAT */
	private JTable table, table2, table3;
	private static JPanel panel, panel2, panel3, panel4;
	private JLabel[] contenitoreJLabel;
	private int [] JLabelVisibili;
	private int rand=0, riga=0, colonna=0, posComp=0, totFramm=30720;
	private int [][] settLiberi;
	private JMenuBar menuBar;
	private JMenu menu, submenu;
	private JMenuItem menuItem;
	private JLabel 	a01L, a02L, a03L, a04L, a05L, a06L, a07L, a08L, a09L, a10L, a11L, a12L,
				b01L, b02L, b03L, b04L, b05L, b06L, b07L, b08L, b09L, b10L, b11L, b12L,
				c01L, c02L, c03L, c04L, c05L, c06L, c07L, c08L, c09L, c10L, c11L, c12L,
				d01L, d02L, d03L, d04L, d05L, d06L, d07L, d08L, d09L, d10L, d11L, d12L,
				e01L, e02L, e03L, e04L, e05L, e06L, e07L, e08L, e09L, e10L, e11L, e12L;
	
	/** Il costruttore della classe "AllocazioneSuDisco" richiama il metodo createAndShowGUI(). */
	public AllocazioneSuDisco()
	{ createAndShowGUI(); }
	
	/** Crea e mostra il frame principale. */
	public void createAndShowGUI()
	{	
		setTitle ("Allocazione di blocchi a file su disco"); /** testo sulla barra del titolo */
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(200,100,890,740); /** posizione e dimensione frame */
		createControls();
		addComponentsToPane();
		createMenu();
		setVisible(true); /** visualizza il frame */
	}
	
	/** Crea i controlli grafici del frame, come i bottoni e alcuni pannelli, e richiama dei metodi che creano i restanti pannelli. */
	public void createControls()
	{	
		/** Crea il bottone "Scrivi un file..." e lo associa all'evento "evento1". */
		button1 = new JButton("Scrivi un file...");
		button1.setActionCommand("evento1");
		button1.addActionListener(this);
		button1.setBounds(20,18,220,30);
		
		/** Crea il bottone "Elimina file..." e lo associa all'evento "evento2". */
		button2 = new JButton("Elimina file...");
		button2.setActionCommand("evento2");
		button2.addActionListener(this);
		button2.setBounds(20,58,220,30);
		
		/** Crea il bottone "Formatta" e lo associa all'evento "evento3". */
		button3 = new JButton("Formatta");
		button3.setActionCommand("evento3");
		button3.addActionListener(this);
		button3.setBounds(20,98,220,30);
		
		/** Crea il pannello con le informazioni riguardanti lo spazio su disco. */
		panel4 = new JPanel();
		Font fontLab = new Font("Dialog", Font.PLAIN, 10);
		c1 = new JLabel("Capacità settore di traccia: byte 512");
		c1.setFont(fontLab);
		c2 = new JLabel("Capacità totale disco: byte 30720");
		c2.setFont(fontLab);
		spazioOccupato=0;
		c3 = new JLabel("Spazio occupato: byte "+ spazioOccupato);
		c3.setFont(fontLab);
		spazioDisponibile= 30720;
		c4 = new JLabel("Spazio disponibile: byte" + spazioDisponibile);
		c4.setFont(fontLab);
		c5 = new JLabel("                                    (di " + spazioDisponibile+")");
		c5.setFont(fontLab);
		panel4.add(c1);
		panel4.add(c2);
		panel4.add(c3);
		panel4.add(c4);
		panel4.add(c5);
		panel4.setBounds(630,530,220,130);
		panel4.setBorder(BorderFactory.createTitledBorder("Informazioni"));
		
		/** Metodi che creano i restanti pannelli: */
		creaJLabelDisco();  
		creaTabellaElencoFile();
		creaFAT();
		creaBitMap();
	}
	
	/** Crea la tabella e il pannello riguardanti l'elenco dei file. */
	public void creaTabellaElencoFile()
	{	
		ElencoFile = new String[60][3];
		for (int i=0; i<=59; i++)
		{	ElencoFile[i][0] = "# "+i;
			ElencoFile[i][1] = ""; 
			ElencoFile[i][2] = ""; 
		}
		panel = new JPanel();
		String[] nomeColonne = {"-",
						"Nome file",
						"Dimensione"};
		table = new JTable(ElencoFile,nomeColonne);
		TableColumn col = table.getColumnModel().getColumn(0);
		col.setPreferredWidth(35);
		JScrollPane pane = new JScrollPane(table);
		pane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		pane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		pane.setPreferredSize(new Dimension(190, 325));
		panel.add(pane);
		panel.setBounds(20,145,220,365);
		panel.setBorder(BorderFactory.createTitledBorder("File su disco"));
	}
	
	/** Crea la tabella e il pannello riguardanti la FAT. */
	public void creaFAT()
	{	
		FAT = new String[60][3];
		for (int i=0; i<=59; i++)
		{	FAT[i][0] = ""+i; 		/** indici crescenti da 0 a 59 */
			FAT[i][1] = "";		/** ci andrà il numero del settore e alla fine la X */
			FAT[i][2] = "";		/** ci andrà il numero dell'indice di ElencoFile collegato a quel file */
		}
		panel3 = new JPanel();
		String[] nomeColonne3 = {"-","-","#"};
		table3 = new JTable(FAT,nomeColonne3);
		JScrollPane pane3 = new JScrollPane(table3);
		pane3.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		pane3.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER); 
		pane3.setPreferredSize(new Dimension(70, 470));
		panel3.add(pane3);
		panel3.setBounds(770,10,80,500);
		panel3.setBorder(BorderFactory.createTitledBorder("FAT"));
	}
	
	/** Crea la tabella e il pannello riguardanti la Bit Map. */
	public void creaBitMap()
	{	
		BitMap = new String[6][13];
		BitMap[0][0] = "-";
		for (int j=1; j<=12; j++)
		{	
			BitMap[0][j] = "S ("+(j-1)+")";
		}
		for (int i=1; i<=5; i++)
		{
			BitMap[i][0] = "T ("+(i-1)+")";
		}
		for (int i=1; i<=5; i++)
		{	for (int j=1; j<=12; j++)
			{
				BitMap[i][j] = "0";
			}
		}
		panel2 = new JPanel();
		String[] nomeColonne2 = {"", "", "", "", "", "", "", "", "", "", "", "", ""};
		table2 = new JTable(BitMap, nomeColonne2);
		JScrollPane pane2 = new JScrollPane(table2);
		pane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		pane2.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER); 
		pane2.setPreferredSize(new Dimension(590, 100));
		panel2.add(pane2);
		panel2.setBounds(20,530,600,130);
		panel2.setBorder(BorderFactory.createTitledBorder("BitMap   (T=traccia; S=settore)"));
	}
	
	/** Crea la parte centrale del frame contenente l'immagine rappresentativa del disco. */
	public void creaJLabelDisco()
	{	
		/** Crea la JLabel contenente l'immagine del disco "BASE.png". */
		ImageIcon base = new ImageIcon("../img/BASE.png");
		sfondo = new JLabel(base);
		sfondo.setBounds(250,10,500,500);
		sfondo.setBorder(BorderFactory.createTitledBorder("Disco"));
		
		/** Crea la JLabel contenente l'immagine del disco "BASENUM.png". */
		ImageIcon base2 = new ImageIcon("../img/BASENUM.png");
		sfondonum = new JLabel(base2);
		sfondonum.setBounds(250,28,500,480);
		
		/** Crea la JLabel contenente l'immagine del disco "BASESET.png". */
		ImageIcon base3 = new ImageIcon("../img/BASESET.png");
		sfondoset = new JLabel(base3);
		sfondoset.setBounds(250,28,500,480);
		
		/** Crea un array di JLabel, "contenitoreJLabel". */
		contenitoreJLabel = new JLabel[60];

		/** Vengono adesso create le singole JLabel contenenti ciascuna una ImageIcon con l'immagine di un blocco. */
		/** Successivamente, ogni JLabel viene aggiunta all'array di JLabel "contenitoreJLabel". */
		ImageIcon a01 = new ImageIcon("../img/a01.png");
		a01L = new JLabel(a01);
		a01L.setBounds(250,20,500,500);
		ImageIcon a02 = new ImageIcon("../img/a02.png");
		a02L = new JLabel(a02);
		a02L.setBounds(250,20,500,500);
		ImageIcon a03 = new ImageIcon("../img/a03.png");
		a03L = new JLabel(a03);
		a03L.setBounds(250,20,500,500);
		ImageIcon a04 = new ImageIcon("../img/a04.png");
		a04L = new JLabel(a04);
		a04L.setBounds(250,20,500,500);
		ImageIcon a05 = new ImageIcon("../img/a05.png");
		a05L = new JLabel(a05);
		a05L.setBounds(250,20,500,500);
		ImageIcon a06 = new ImageIcon("../img/a06.png");
		a06L = new JLabel(a06);
		a06L.setBounds(250,20,500,500);
		ImageIcon a07 = new ImageIcon("../img/a07.png");
		a07L = new JLabel(a07);
		a07L.setBounds(250,20,500,500);
		ImageIcon a08 = new ImageIcon("../img/a08.png");
		a08L = new JLabel(a08);
		a08L.setBounds(250,20,500,500);
		ImageIcon a09 = new ImageIcon("../img/a09.png");
		a09L = new JLabel(a09);
		a09L.setBounds(250,20,500,500);
		ImageIcon a10 = new ImageIcon("../img/a10.png");
		a10L = new JLabel(a10);
		a10L.setBounds(250,20,500,500);
		ImageIcon a11 = new ImageIcon("../img/a11.png");
		a11L = new JLabel(a11);
		a11L.setBounds(250,20,500,500);
		ImageIcon a12 = new ImageIcon("../img/a12.png");
		a12L = new JLabel(a12);
		a12L.setBounds(250,20,500,500);
		
		contenitoreJLabel[0] = a01L;
		contenitoreJLabel[1] = a02L;
		contenitoreJLabel[2] = a03L;
		contenitoreJLabel[3] = a04L;
		contenitoreJLabel[4] = a05L;
		contenitoreJLabel[5] = a06L;
		contenitoreJLabel[6] = a07L;
		contenitoreJLabel[7] = a08L;
		contenitoreJLabel[8] = a09L;
		contenitoreJLabel[9] = a10L;
		contenitoreJLabel[10] = a11L;
		contenitoreJLabel[11] = a12L;
		
		ImageIcon b01 = new ImageIcon("../img/b01.png");
		b01L = new JLabel(b01);
		b01L.setBounds(250,20,500,500);
		ImageIcon b02 = new ImageIcon("../img/b02.png");
		b02L = new JLabel(b02);
		b02L.setBounds(250,20,500,500);
		ImageIcon b03 = new ImageIcon("../img/b03.png");
		b03L = new JLabel(b03);
		b03L.setBounds(250,20,500,500);
		ImageIcon b04 = new ImageIcon("../img/b04.png");
		b04L = new JLabel(b04);
		b04L.setBounds(250,20,500,500);
		ImageIcon b05 = new ImageIcon("../img/b05.png");
		b05L = new JLabel(b05);
		b05L.setBounds(250,20,500,500);
		ImageIcon b06 = new ImageIcon("../img/b06.png");
		b06L = new JLabel(b06);
		b06L.setBounds(250,20,500,500);
		ImageIcon b07 = new ImageIcon("../img/b07.png");
		b07L = new JLabel(b07);
		b07L.setBounds(250,20,500,500);
		ImageIcon b08 = new ImageIcon("../img/b08.png");
		b08L = new JLabel(b08);
		b08L.setBounds(250,20,500,500);
		ImageIcon b09 = new ImageIcon("../img/b09.png");
		b09L = new JLabel(b09);
		b09L.setBounds(250,20,500,500);
		ImageIcon b10 = new ImageIcon("../img/b10.png");
		b10L = new JLabel(b10);
		b10L.setBounds(250,20,500,500);
		ImageIcon b11 = new ImageIcon("../img/b11.png");
		b11L = new JLabel(b11);
		b11L.setBounds(250,20,500,500);
		ImageIcon b12 = new ImageIcon("../img/b12.png");
		b12L = new JLabel(b12);
		b12L.setBounds(250,20,500,500);
		
		contenitoreJLabel[12] = b01L;
		contenitoreJLabel[13] = b02L;
		contenitoreJLabel[14] = b03L;
		contenitoreJLabel[15] = b04L;
		contenitoreJLabel[16] = b05L;
		contenitoreJLabel[17] = b06L;
		contenitoreJLabel[18] = b07L;
		contenitoreJLabel[19] = b08L;
		contenitoreJLabel[20] = b09L;
		contenitoreJLabel[21] = b10L;
		contenitoreJLabel[22] = b11L;
		contenitoreJLabel[23] = b12L;
		
		ImageIcon c01 = new ImageIcon("../img/c01.png");
		c01L = new JLabel(c01);
		c01L.setBounds(250,20,500,500);
		ImageIcon c02 = new ImageIcon("../img/c02.png");
		c02L = new JLabel(c02);
		c02L.setBounds(250,20,500,500);
		ImageIcon c03 = new ImageIcon("../img/c03.png");
		c03L = new JLabel(c03);
		c03L.setBounds(250,20,500,500);
		ImageIcon c04 = new ImageIcon("../img/c04.png");
		c04L = new JLabel(c04);
		c04L.setBounds(250,20,500,500);
		ImageIcon c05 = new ImageIcon("../img/c05.png");
		c05L = new JLabel(c05);
		c05L.setBounds(250,20,500,500);
		ImageIcon c06 = new ImageIcon("../img/c06.png");
		c06L = new JLabel(c06);
		c06L.setBounds(250,20,500,500);
		ImageIcon c07 = new ImageIcon("../img/c07.png");
		c07L = new JLabel(c07);
		c07L.setBounds(250,20,500,500);
		ImageIcon c08 = new ImageIcon("../img/c08.png");
		c08L = new JLabel(c08);
		c08L.setBounds(250,20,500,500);
		ImageIcon c09 = new ImageIcon("../img/c09.png");
		c09L = new JLabel(c09);
		c09L.setBounds(250,20,500,500);
		ImageIcon c10 = new ImageIcon("../img/c10.png");
		c10L = new JLabel(c10);
		c10L.setBounds(250,20,500,500);
		ImageIcon c11 = new ImageIcon("../img/c11.png");
		c11L = new JLabel(c11);
		c11L.setBounds(250,20,500,500);
		ImageIcon c12 = new ImageIcon("../img/c12.png");
		c12L = new JLabel(c12);
		c12L.setBounds(250,20,500,500);
		
		contenitoreJLabel[24] = c01L;
		contenitoreJLabel[25] = c02L;
		contenitoreJLabel[26] = c03L;
		contenitoreJLabel[27] = c04L;
		contenitoreJLabel[28] = c05L;
		contenitoreJLabel[29] = c06L;
		contenitoreJLabel[30] = c07L;
		contenitoreJLabel[31] = c08L;
		contenitoreJLabel[32] = c09L;
		contenitoreJLabel[33] = c10L;
		contenitoreJLabel[34] = c11L;
		contenitoreJLabel[35] = c12L;
		
		ImageIcon d01 = new ImageIcon("../img/d01.png");
		d01L = new JLabel(d01);
		d01L.setBounds(250,20,500,500);
		ImageIcon d02 = new ImageIcon("../img/d02.png");
		d02L = new JLabel(d02);
		d02L.setBounds(250,20,500,500);
		ImageIcon d03 = new ImageIcon("../img/d03.png");
		d03L = new JLabel(d03);
		d03L.setBounds(250,20,500,500);
		ImageIcon d04 = new ImageIcon("../img/d04.png");
		d04L = new JLabel(d04);
		d04L.setBounds(250,20,500,500);
		ImageIcon d05 = new ImageIcon("../img/d05.png");
		d05L = new JLabel(d05);
		d05L.setBounds(250,20,500,500);
		ImageIcon d06 = new ImageIcon("../img/d06.png");
		d06L = new JLabel(d06);
		d06L.setBounds(250,20,500,500);
		ImageIcon d07 = new ImageIcon("../img/d07.png");
		d07L = new JLabel(d07);
		d07L.setBounds(250,20,500,500);
		ImageIcon d08 = new ImageIcon("../img/d08.png");
		d08L = new JLabel(d08);
		d08L.setBounds(250,20,500,500);
		ImageIcon d09 = new ImageIcon("../img/d09.png");
		d09L = new JLabel(d09);
		d09L.setBounds(250,20,500,500);
		ImageIcon d10 = new ImageIcon("../img/d10.png");
		d10L = new JLabel(d10);
		d10L.setBounds(250,20,500,500);
		ImageIcon d11 = new ImageIcon("../img/d11.png");
		d11L = new JLabel(d11);
		d11L.setBounds(250,20,500,500);
		ImageIcon d12 = new ImageIcon("../img/d12.png");
		d12L = new JLabel(d12);
		d12L.setBounds(250,20,500,500);
		
		contenitoreJLabel[36] = d01L;
		contenitoreJLabel[37] = d02L;
		contenitoreJLabel[38] = d03L;
		contenitoreJLabel[39] = d04L;
		contenitoreJLabel[40] = d05L;
		contenitoreJLabel[41] = d06L;
		contenitoreJLabel[42] = d07L;
		contenitoreJLabel[43] = d08L;
		contenitoreJLabel[44] = d09L;
		contenitoreJLabel[45] = d10L;
		contenitoreJLabel[46] = d11L;
		contenitoreJLabel[47] = d12L;
		
		ImageIcon e01 = new ImageIcon("../img/e01.png");
		e01L = new JLabel(e01);
		e01L.setBounds(250,20,500,500);
		ImageIcon e02 = new ImageIcon("../img/e02.png");
		e02L = new JLabel(e02);
		e02L.setBounds(250,20,500,500);
		ImageIcon e03 = new ImageIcon("../img/e03.png");
		e03L = new JLabel(e03);
		e03L.setBounds(250,20,500,500);
		ImageIcon e04 = new ImageIcon("../img/e04.png");
		e04L = new JLabel(e04);
		e04L.setBounds(250,20,500,500);
		ImageIcon e05 = new ImageIcon("../img/e05.png");
		e05L = new JLabel(e05);
		e05L.setBounds(250,20,500,500);
		ImageIcon e06 = new ImageIcon("../img/e06.png");
		e06L = new JLabel(e06);
		e06L.setBounds(250,20,500,500);
		ImageIcon e07 = new ImageIcon("../img/e07.png");
		e07L = new JLabel(e07);
		e07L.setBounds(250,20,500,500);
		ImageIcon e08 = new ImageIcon("../img/e08.png");
		e08L = new JLabel(e08);
		e08L.setBounds(250,20,500,500);
		ImageIcon e09 = new ImageIcon("../img/e09.png");
		e09L = new JLabel(e09);
		e09L.setBounds(250,20,500,500);
		ImageIcon e10 = new ImageIcon("../img/e10.png");
		e10L = new JLabel(e10);
		e10L.setBounds(250,20,500,500);
		ImageIcon e11 = new ImageIcon("../img/e11.png");
		e11L = new JLabel(e11);
		e11L.setBounds(250,20,500,500);
		ImageIcon e12 = new ImageIcon("../img/e12.png");
		e12L = new JLabel(e12);
		e12L.setBounds(250,20,500,500);
		
		contenitoreJLabel[48] = e01L;
		contenitoreJLabel[49] = e02L;
		contenitoreJLabel[50] = e03L;
		contenitoreJLabel[51] = e04L;
		contenitoreJLabel[52] = e05L;
		contenitoreJLabel[53] = e06L;
		contenitoreJLabel[54] = e07L;
		contenitoreJLabel[55] = e08L;
		contenitoreJLabel[56] = e09L;
		contenitoreJLabel[57] = e10L;
		contenitoreJLabel[58] = e11L;
		contenitoreJLabel[59] = e12L;
		
		/** Viene creato un array di int, "JLabelVisibili". */
		JLabelVisibili = new int [60];
		for (int i=0; i<=59; i++) 
			{ JLabelVisibili[i] = 0; } /** 
							*	Ogni elemento dell'array "JLabelVisibili" viene inizializzato a 0.
							*	Questo array serve a darci informazioni riguardo la visibilità 
							*	di ognuna delle 60 JLabel raffiguranti i blocchi:
							*	0 se si vuole che il blocco non sia visibile,
							*	1 se lo si vuole rendere visibile.
							*/
	}
	
	
	/** Aggiunge tutti i pannelli e i bottoni al frame. */
	public void addComponentsToPane()
	{	
		setLayout(null);
		getContentPane().add(button1, BorderLayout.CENTER);
		getContentPane().add(button2, BorderLayout.CENTER);
		getContentPane().add(button3, BorderLayout.CENTER);
		getContentPane().add(panel, BorderLayout.CENTER); /** Aggiunge il pannello in cui compare l'elenco dei file. */
		getContentPane().add(panel2, BorderLayout.CENTER); /** Aggiunge il pannello in cui compare la BitMap. */
		getContentPane().add(panel3, BorderLayout.CENTER); /** Aggiunge il pannello in cui compare la FAT. */
		getContentPane().add(sfondonum, BorderLayout.CENTER);
		getContentPane().add(sfondoset, BorderLayout.CENTER);
		getContentPane().add(sfondo, BorderLayout.CENTER);
		getContentPane().add(panel4, BorderLayout.CENTER); /** Aggiunge il pannello in cui compaiono le informazioni riguardanti lo spazio su disco. */
	}
	
	/** Crea la barra dei menu. */
	public void createMenu()
	{	
		menuBar = new JMenuBar();
		
		menu = new JMenu("Menu");
		menuBar.add(menu);
		
		menuItem = new JMenuItem("About");
		menu.add(menuItem);
		menuItem.setActionCommand("About");
		menuItem.addActionListener(this);
		
		menuItem = new JMenuItem("Exit");
		menu.add(menuItem);
		menuItem.setActionCommand("Exit");
		menuItem.addActionListener(this);
		
		setJMenuBar(menuBar);
	}
	
	/** Inserisce un nuovo file nel disco.
	*
	* @param dimStr la dimensione del file da inserire
	* @param posizioneFile la posizione del file da inserire
	* @return "true" se l'inserimento è andato a buon fine, "false" altrimenti
	*/
	public boolean inserisciFile(String dimStr, int posizioneFile)
	{	
		rand=0;
		riga=0;
		colonna=0;
		posComp=0;
		int dim = Integer.parseInt(dimStr); /** dimensione file */
		if (dim==0) {ALARM(1); return false;}
		int n = dim/512;		/** n è il numero di settori di traccia (512 byte l'uno) che occuperà il file */
		int framm = dim%512;
		int ciclo=0;
		if (framm==0) 	
			ciclo = n;
		else 
			ciclo = n+1;	/** se il file non occupa esattamente n settori, ma è più grande, se ne aggiunge uno */
		if (n==0)
			ciclo = 1;		/** se il file occupa meno di 512 byte, si occupa un solo settore di traccia */
		int penultimo=0;
		int ultimo=0;
		for (int l=1; l<=ciclo; l++) /** per ogni settore da inserire... */
		{
			int nSettLiberi=0;
			for (int i=1; i<=5; i++)
			{	for (int j=1; j<=12; j++)
				{	if (BitMap[i][j] == "0")
						nSettLiberi++; /** "nSettLiberi" è un contatore che indica quanti zeri sono presenti nella BitMap, cioè il numero di settori liberi. */
				}
			}
			if (nSettLiberi == 0) {ALARM(2); return false;}
			if ((l==1)&&(nSettLiberi < ciclo)) {ALARM(3); return false;}
			settLiberi = new int [nSettLiberi][2];
			int k=0,y,g;
			for (y=1; y<=5; y++)
			{	for (g=1; g<=12; g++)
				{	if (BitMap[y][g] == "0")
					{	settLiberi[k][0] = y-1;	/** in un vettore bidimensionale, "settLiberi", inserisce la posizione di ogni settore libero. */
						settLiberi[k][1] = g-1;
						k++;
					}
				}
			}
			riga = settLiberi[settLiberi.length-1][0];		/** fra i settori liberi, sceglie un settore (la riga) */
			colonna = settLiberi[settLiberi.length-1][1];	/** fra i settori liberi, sceglie un settore (la colonna) */
			for (int i=settLiberi.length-1; i>=0; i--)
			{	if ((5< settLiberi[i][1])&& (settLiberi[i][1]< 12)) /** sceglie i settori liberi partendo dalla parte sinistra del disco */
				{	riga = settLiberi[i][0];			
					colonna = settLiberi[i][1];
				}
			}
			penultimo = ultimo;	/** il penultimo blocco inserito diventa l'ultimo */
			posComp = (riga*12)+(colonna); /** trasforma riga e colonna in numero di settore di traccia (blocco) */
			ultimo = posComp;
			if (l==1)		/** nel caso in cui c'è un solo blocco da inserire, scrive sulla FAT la posizione del file e la "X" che indica che esso è terminato */
			{	FAT[posComp][2] = ""+posizioneFile;
				FAT[posComp][1] = "X";
			}
			else			/** altrimenti scrive nella FAT (in particolare nella riga in cui è stato inserito il penultimo blocco) la posizione dell'ultimo blocco inserito */
				FAT[penultimo][1] = ""+ultimo;
			getContentPane().add(contenitoreJLabel[posComp], BorderLayout.CENTER); /** al frame viene aggiunta la JLabel contenuta nell'array "contenitoreJLabel", in posizione "posComp". */
			JLabelVisibili[posComp] = 1; /** l'array "JLabelVisibili" viene aggiornato, indicando con "1" che la JLabel in posizione "posComp" è stata resa visibile */
			BitMap[riga+1][colonna+1] = "1"; /** la Bit Map viene aggiornata */
		}
		FAT[ultimo][1] = "X"; /** fine del file */
		spazioOccupato = spazioOccupato+dim;
		c3.setText("Spazio occupato: byte "+ spazioOccupato);
		totFramm = totFramm-(512*ciclo);
		c4.setText("Spazio disponibile: byte "+ ( totFramm)); /** totFramm toglie a 30720 i settori occupati */
		spazioDisponibile = 30720-spazioOccupato;		/** lo spazio effettivamente disponibile */
		c5.setText("                                    (di " +(spazioDisponibile)+")");
		return true;
	}
	
	/** Mostra il messaggio di errore corrispondente al numero intero indicato dal parametro. */
	public void ALARM(int n)
	{	
		switch (n)
		{	
			case 1: JOptionPane.showMessageDialog(this,"Input errato. Nessun file inserito.","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 2: JOptionPane.showMessageDialog(this, "Memoria disco piena!","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 3: JOptionPane.showMessageDialog(this, "Spazio insufficiente!","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 4: JOptionPane.showMessageDialog(this, "Errore generale. File non presente nella FAT.","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 5: JOptionPane.showMessageDialog(this, "Nessun file presente sul disco.","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 6: JOptionPane.showMessageDialog(this, "File non trovato!","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 7: JOptionPane.showMessageDialog(this, "E' già presente un file con quel nome.","Errore",JOptionPane.ERROR_MESSAGE); break;
			case 8: JOptionPane.showMessageDialog(this, "Non sono ammessi i caratteri: !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~","Errore",JOptionPane.ERROR_MESSAGE); break;
		}
	}
	
	/** Gestisce le azioni dei bottoni e del menu. */
	public void actionPerformed(ActionEvent e)  
	{	
		String nome = "";
		String dimensione = "";
		String car;
		if (e.getActionCommand().equals("evento1")) /** Click sul bottone "Scrivi un file" */
		{	if (totFramm == 0) {ALARM(2); return; }
			boolean flag=false, inserimentoEffettuato=false, nomeCorretto=false;
			int i;
			for (i=0; i<=59;i++)
			{	if ((flag==false) && (ElencoFile[i][1] == ""))
				{	nome = JOptionPane.showInputDialog("Inserisci il nome del file:");
					if (nome == null) {ALARM(1); return;}
					for (int t=0; t<=59; t++)
					{	if (ElencoFile[t][1].equals(nome))
						{ ALARM(7); return; }
					}
					for (int h=0; h<=nome.length()-1; h++) /** Controlla se il nome del file immesso ha caratteri speciali... */
					{	car = Character.toString(nome.charAt(h));
						Pattern pattern1 = Pattern.compile("\\p{Punct}");
						if (pattern1.matcher(car).matches()) /** ...e se li ha... */
						{ ALARM(8); return; } /** ...invia il messaggio di errore ed esce dal metodo. */
					}
					dimensione = JOptionPane.showInputDialog("Inserisci la dimensione del file (in byte):");
					if (dimensione == null) {ALARM(1); return;}
					Pattern pattern = Pattern.compile("\\d+");
					if (pattern.matcher(dimensione).matches())
					{	inserimentoEffettuato = inserisciFile(dimensione, i); /** inserisce il file */
						if (inserimentoEffettuato)
						{	ElencoFile[i][1] = nome;
							ElencoFile[i][2] = dimensione;
						}
						else return;
					}
					else {ALARM(1); return;}
					flag=true;
					i=60;
				}
			}
			if (flag==false) {ALARM(2); return;}
			repaint();
		}
		if (e.getActionCommand().equals("evento2")) /** Click sul bottone: "Cancella file" */
		{	if (spazioOccupato==0) {ALARM(5); return;}
			String nome2 = "";
			int cicli=0;
			nome2 = JOptionPane.showInputDialog("Inserisci il nome del file da eliminare:");
			boolean flag2=false;
			String str="";
			for (int i=0; i<=59; i++)
			{	if (ElencoFile[i][1].equals(nome2)) 
				{	Object[] options = {"Sì", "No", "Annulla"};
					int n = JOptionPane.showOptionDialog(this, "Eliminare '"+nome2+"'?", "Elimina file",
									JOptionPane.YES_NO_CANCEL_OPTION,
									JOptionPane.QUESTION_MESSAGE,
									null, options, options[2]);
					if (n == JOptionPane.YES_OPTION)
					{	for (int j=0; j<=59; j++)
						{	if (FAT[j][2].equals(""+(i)))	
							{	flag2=true;
								int f=Integer.parseInt(FAT[j][0]); 
								int d=0, p=0;
								while (!(str.equals("X")))	/** fino a quando non si arriva alla fine del "percorso di settori" del file */
								{	str = FAT[f][1]; /** str è il prossimo settore... */
									if (!(FAT[f][1].equals("X")))
										d = Integer.parseInt(FAT[f][1]);
									p = Integer.parseInt(FAT[f][0]);
									BitMap[((int)((p)/12)+1)][((int)((p)%12)+1)] = "0";
									getContentPane().remove(contenitoreJLabel[p]); 
									JLabelVisibili[p] = 0;
									FAT[f][1]="";
									FAT[f][2]="";
									f = d; /** ... ed è anche il prossimo indice dove andremo */
									cicli++; /** La variabile "cicli" conta quanti erano i settori di quel file. */
								}
							}	
						}
						if (flag2==false) {ALARM(4); return;}
						spazioOccupato = spazioOccupato-Integer.parseInt((ElencoFile[i][2]));
						c3.setText("Spazio occupato: byte "+ spazioOccupato); 
						totFramm = totFramm+(cicli*512);
						c4.setText("Spazio disponibile: byte "+ (totFramm)); 
						spazioDisponibile = 30720-spazioOccupato;
						c5.setText("                                    (di " +spazioDisponibile+")");
						ElencoFile[i][0] = "# "+i;
						ElencoFile[i][1] = ""; 
						ElencoFile[i][2] = ""; 
						repaint();
						return;
					}
					else return;
				}
			}
			if (!(nome2==null)) ALARM(6);
		}
		if (e.getActionCommand().equals("evento3")) /** Click sul bottone "Formatta" */
		{	Object[] options = {"Sì", "No", "Annulla"};
			int n = JOptionPane.showOptionDialog(this, "Formattare il disco?", "Formatta",
										JOptionPane.YES_NO_CANCEL_OPTION,
										JOptionPane.QUESTION_MESSAGE,
										null, options, options[2]);
			if (n == JOptionPane.YES_OPTION) /** se è stata data conferma, si cancelleranno tutti i contenuti degli array bidimensionali */
			{	for (int i=0; i<=59; i++)	
				{	ElencoFile[i][0] = "# "+(i);
					ElencoFile[i][1] = ""; 
					ElencoFile[i][2] = ""; 
				}
				BitMap[0][0] = "-";
				for (int j=1; j<=12; j++)
				{
					BitMap[0][j] = "S ("+(j-1)+")";
				}
				for (int i=1; i<=5; i++)
				{
					BitMap[i][0] = "T ("+(i-1)+")";
				}
				for (int i=1; i<=5; i++)
				{
					for (int j=1; j<=12; j++)
					{
						BitMap[i][j] = "0";
					}
				}
				for (int i=0; i<=JLabelVisibili.length-1; i++)
				{	if (JLabelVisibili[i] == 1)
					{	getContentPane().remove(contenitoreJLabel[i]); /** rimuove le JLabel con le immagini dei settori */
						JLabelVisibili[i] = 0;
					}
				}
				for (int i=0; i<=59; i++)
				{	FAT[i][0] = ""+i;
					FAT[i][1] = "";
					FAT[i][2] = "";
				}
				spazioOccupato = 0;
				c3.setText("Spazio occupato: byte "+ spazioOccupato); 
				spazioDisponibile = 30720;
				totFramm = 30720;
				c4.setText("Spazio disponibile: byte "+  totFramm); 
				c5.setText("                                    (di " + spazioDisponibile+")");
				repaint();
				JOptionPane.showMessageDialog(this, "Operazione effettuata con successo.");
			}
			else 
			{	if (n == JOptionPane.NO_OPTION)
					return;
				else 
					return;
			}
		}
		if (e.getActionCommand().equals("About")) /** Click su "Menu > About" */
		{	JOptionPane.showMessageDialog(this,"Allocazione di blocchi a file su disco\n"+
									"Autore: Jessica Catania\n"+
									"Versione: 1.0", "About", JOptionPane.PLAIN_MESSAGE);
		}
		if (e.getActionCommand().equals("Exit")) /** Click su "Menu > Exit" */
		{ System.exit(0); }
	}
	
	/** Main del programma. Crea un oggetto di classe "AllocazioneSuDisco". */
	public static void main(String[] args)
	{ AllocazioneSuDisco Progetto1 = new AllocazioneSuDisco(); }
}